% Script_Big_Parallelepiped

% Configuration parameters for the model we are going to simulate
% Shows the model we are going to simulate on this script

% This rotine must star on the folder "20090602 Big Parallelepiped" and it ends on
% the same folder "20090602 Big Parallelepiped" 

clear
load 20240116T205226_InitionConditionNotProblemsTogether
load 20240116T205226_InitionConditionProblemsTogether

TimeStart = datevec(now); % Its is a 6x1 vector containing:  [Year Month Day Hour Minute Second]

eval(['mkdir ', DATESTR(datenum(TimeStart),30), '_Tomography']);
copyfile('Script_Big_Parallelepiped.m',['', DATESTR(datenum(TimeStart),30), '_Script_Big_Parallelepiped.m']);

% open Script_Big_Parallelepiped.m
% open Sim_IC_All.m

% cd ..
% cd InitialCondiction
% eval(['mkdir ', DATESTR(datenum(TimeStart),30), '_InitialCondiction']);
% run Sim_IC_All % This rotine must star on the folder "InitialCondiction" and it ends on the same folder "InitialCondiction" 
% cd ..
% cd '20090927 Big Parallelepiped'

% load 20091221T070648_InitionConditionNotProblemsTogether
% load 20091221T070648_InitionConditionProblemsTogether

startime = 0;
stoptime = 900; % We do not need to run the simulink simulation for a very long time, because during the encryption algorithm it will not run so long...
stepsize = 0.01;

% ICPpointer =     1 + length(InitionConditionProblems_20090429T172308);
% ICNPpointer = 1 + length(InitionConditionNotProblems_20090429T172308);
% InitionConditionNotProblems = InitionConditionNotProblems_20090429T172308;
% InitionConditionProblems =       InitionConditionProblems_20090429T172308;


% Inition Condiction CI 06A
XZeroStart = min(min(InitionConditionNotProblems(:,1)),min(InitionConditionProblems(:,1)));  
XZeroStep =  100.0;
XZeroEnd = max(max(InitionConditionNotProblems(:,1)),max(InitionConditionProblems(:,1)));
YZeroStart = min(min(InitionConditionNotProblems(:,2)),min(InitionConditionProblems(:,2)));  
YZeroStep =  250.0;      
YZeroEnd = max(max(InitionConditionNotProblems(:,2)),max(InitionConditionProblems(:,2)));
ZZeroStart = min(min(InitionConditionNotProblems(:,3)),min(InitionConditionProblems(:,3)));  
ZZeroStep =  1;      
ZZeroEnd = max(max(InitionConditionNotProblems(:,3)),max(InitionConditionProblems(:,3)));

XGuard = 0;
YGuard = 0;
ZGuard = 0;

XMin = -8;    XMinGuard = XMin - XGuard;  
XMax = +8;    XMaxGuard = XMax + XGuard;  

YMin = -4;   YMinGuard = YMin - YGuard;  
YMax = 4;   YMaxGuard = YMax + YGuard;  

ZMin = 10;    ZMinGuard = ZMin - ZGuard;  
ZMax = 12;   ZMaxGuard = ZMax + ZGuard;


% ZStep= +100;      

PercentageProgress = 2;
NumZZero = length(ZZeroStart : ZZeroStep : ZZeroEnd);
NumberSimulationsTotal = NumZZero;
NumberSimulationsLeft = NumberSimulationsTotal; % Before starting the simulation, the NumberSimulationsLeft is equal to the  NumberSimulationsTotal

% Inition Condiction CI 06A
% for zzero = ZZeroStart : ZZeroStep : ZZeroEnd;
for zzero = -50 : 0.125 : 16;
    
	SimStart = now;            
	
	ICNP =      find(InitionConditionNotProblems(:,3) == zzero);
	ICP =       find(   InitionConditionProblems(:,3) == zzero);
    ICPpoles =  find(   InitionConditionProblems(:,3) == zzero & InitionConditionProblems(:,5) == 1);
    
	ICNPq =     find(InitionConditionNotProblems(:,3) == zzero & InitionConditionNotProblems(:,1) >= XMinGuard & InitionConditionNotProblems(:,1) <= XMaxGuard & InitionConditionNotProblems(:,2) >= YMinGuard & InitionConditionNotProblems(:,2) <= YMaxGuard);
	ICPq =      find(   InitionConditionProblems(:,3) == zzero & InitionConditionProblems(:,1)    >= XMinGuard &    InitionConditionProblems(:,1) <= XMaxGuard &    InitionConditionProblems(:,2) >= YMinGuard &    InitionConditionProblems(:,2) <= YMaxGuard  &  InitionConditionProblems(:,5) == 0 );
    ICPpolesq = find(   InitionConditionProblems(:,3) == zzero & InitionConditionProblems(:,1)    >= XMinGuard &    InitionConditionProblems(:,1) <= XMaxGuard &    InitionConditionProblems(:,2) >= YMinGuard &    InitionConditionProblems(:,2) <= YMaxGuard  &  InitionConditionProblems(:,5) == 1 );
    
	if  length(ICNP) ~= 0 | length(ICP) ~= 0
		figure(5)
		plot(InitionConditionNotProblems(ICNP,1),InitionConditionNotProblems(ICNP,2),'g.'); 
		hold on;
		plot(InitionConditionProblems(ICP,1),InitionConditionProblems(ICP,2),'r.');
        plot(InitionConditionProblems(ICPpoles,1),InitionConditionProblems(ICPpoles,2),'bo');
        if (zzero >= ZMinGuard & zzero <= ZMaxGuard & length(ICPq) == 0)
            plot(XMin:0.1:XMax,YMin,'b.');
            plot(XMin:0.1:XMax,YMax,'b.');
            plot(XMin,YMin:0.1:YMax,'b.');
            plot(XMax,YMin:0.1:YMax,'b.');
            plot(XMinGuard:XMaxGuard,YMinGuard,'b.');
            plot(XMinGuard:XMaxGuard,YMaxGuard,'b.');
            plot(XMinGuard,YMinGuard:YMaxGuard,'b.');
            plot(XMaxGuard,YMinGuard:YMaxGuard,'b.');
        end
        if (zzero >= ZMinGuard & zzero <= ZMaxGuard & length(ICPq) ~= 0)
            plot(XMin:0.1:XMax,YMin,'r.');
            plot(XMin:0.1:XMax,YMax,'r.');
            plot(XMin,YMin:0.1:YMax,'r.');
            plot(XMax,YMin:0.1:YMax,'r.');
            plot(XMinGuard:0.1:XMaxGuard,YMinGuard,'r.');
            plot(XMinGuard:0.1:XMaxGuard,YMaxGuard,'r.');
            plot(XMinGuard,YMinGuard:0.1:YMaxGuard,'r.');
            plot(XMaxGuard,YMinGuard:0.1:YMaxGuard,'r.');
        end
        if (zzero < ZMinGuard | zzero > ZMaxGuard)
            plot(XMin:0.1:XMax,YMin,'y.');
            plot(XMin:0.1:XMax,YMax,'y.');
            plot(XMin,YMin:0.1:YMax,'y.');
            plot(XMax,YMin:0.1:YMax,'y.');
            plot(XMinGuard:0.1:XMaxGuard,YMinGuard,'y.');
            plot(XMinGuard:0.1:XMaxGuard,YMaxGuard,'y.');
            plot(XMinGuard,YMinGuard:0.1:YMaxGuard,'y.');
            plot(XMaxGuard,YMinGuard:0.1:YMaxGuard,'y.');
        end
		grid on; 
        AXIS([-25 25 -30 +30]);
%       AXIS([XMin-12 XMax+12 YMin-6 YMax+6]);
% 		AXIS([XZeroStart-2 XZeroEnd+2 YZeroStart-2 YZeroEnd+2]);
		title(['Map of Good and Bad ICs (Step = ', num2str(stepsize), ', Zzero = ', num2str(zzero), ', Date: ', DATESTR(TimeStart,1), ', Time: ', DATESTR(TimeStart,15), ')']);
		xlabel(['Variable xouts (Xo = ', num2str(XZeroStart), ' : ', num2str(XZeroStep), ' : ', num2str(XZeroEnd),  ' , Yo = ', num2str(YZeroStart), ' : ', num2str(YZeroStep), ' : ', num2str(YZeroEnd), ' , Zo = ', num2str(ZZeroStart), ' : ', num2str(ZZeroStep), ' : ', num2str(ZZeroEnd),')']);
		ylabel(['Variable youts from Lorenz equations']);
		eval(['cd ', DATESTR(datenum(TimeStart),30), '_Tomography']);
		filename = ([DATESTR(datevec(SimStart),30), '_GoodBadIC_Z', num2str(zzero), '.fig']);
		saveas(5, filename, 'fig');
		filename = ([DATESTR(datevec(SimStart),30), '_GoodBadIC_Z', num2str(zzero), '.jpg']);
		saveas(5, filename, 'jpg');
        pause(1)
		cd ..
		close(5)
	end

    NumberSimulationsLeft = NumberSimulationsLeft - 1;
    % Calculation of End of Simulation Time    
    TimeActual = datevec(now); % Its is a 6x1 vector containing:  [Year Month Day Hour Minute Second]
    TimeElapsed = datenum(TimeActual) - datenum(TimeStart); % Time is numerical form in reference to 01JAN0000
    TimeEnd = datenum(TimeActual) + (TimeElapsed/(NumberSimulationsTotal-NumberSimulationsLeft))*(NumberSimulationsLeft);
    Percentage = 100*(NumberSimulationsTotal-NumberSimulationsLeft)/(NumberSimulationsTotal);
    if Percentage > PercentageProgress
        fprintf(1,'%2.0f%% done. Starts: %s. Now: %s. End: %s \n', Percentage, datestr(TimeStart), datestr(now), datestr(TimeEnd))
        PercentageProgress = PercentageProgress + 5;
    end
    
end % for zzero = ZZeroStart : ZZeroStep : ZZeroEnd;

Parallelepiped_Not_Valid_Index = find(InitionConditionProblems(:,3) <= ZMax & InitionConditionProblems(:,3) >= ZMin & InitionConditionProblems(:,2) <= YMax & InitionConditionProblems(:,2) >= YMin & InitionConditionProblems(:,1) <= XMax & InitionConditionProblems(:,1) >= XMin & InitionConditionProblems(:,1) ~= 0 & InitionConditionProblems(:,2) ~= 0);
Parallelepiped_Not_Valid_IC = InitionConditionProblems(Parallelepiped_Not_Valid_Index,1:3);
Parallelepiped_Volume = (XMax-XMin)*(YMax-YMin)*(ZMax-ZMin);
Parallelepiped_Limits(1,1) = XMax;
Parallelepiped_Limits(1,2) = XMin;
Parallelepiped_Limits(1,3) = YMax;
Parallelepiped_Limits(1,4) = YMin;
Parallelepiped_Limits(1,5) = ZMax;
Parallelepiped_Limits(1,6) = ZMin;
if length(Parallelepiped_Not_Valid_IC) == 0
Parallelepiped_Is_It_Valid = 1; % means YES
else
Parallelepiped_Is_It_Valid = 0; % means NO    
end
filename = (['', DATESTR(datenum(TimeStart),30), '_Parallelepiped.mat']);
eval(['save(filename,''Parallelepiped_*'')']);

% Now it plays a sound that indicates the end of the simulation
[SimEnd,FqSp,NBits]=wavread('EndOfSimulation.wav');
soundsc(SimEnd,FqSp)
fprintf('\n')
% Now it saves and prints the End of Simulation Time
EndOfSimulation = datestr(now);
fprintf('The simulations Starts on %s\n', datestr(TimeStart));
fprintf('The simulations Ends on %s\n', datestr(EndOfSimulation));
fprintf('\n')

